<?php

namespace app\controllers;

use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Request;
use Yii;

class AdminController extends Controller
{
    public function behaviors() {
        return [
            'access'=>[
                'class'=>AccessControl::class,
                'rules'=>[
                    [
                        'allow'=>true,
                        'matchCallback'=>function() {
                            return !Yii::$app->user->isGuest && Yii::$app->user->identity->isAdmin();
                        }
                    ]
                ]
            ]
        ];
    }

    public function actionIndex() {
        $requests = Request::find()->all();
        return $this->render('index',['requests'=>$requests]);
    }

    public function actionUpdateStatus($id, $status)
    {
        $request = \app\models\Request::findOne($id);

        if (!$request) {
            throw new \yii\web\NotFoundHttpException('Заявка не найдена');
        }

        $request->status = $status;

        if ($request->save(false)) { // <- отключаем валидацию
            Yii::$app->session->setFlash('success', 'Статус заявки обновлен');
        } else {
            Yii::$app->session->setFlash('error', 'Не удалось обновить статус');
            Yii::error($request->errors);
        }

        return $this->redirect(['admin/index']);
    }

}
