<?php

namespace app\models;

use yii\base\Model;
use Yii;

class LoginForm extends Model
{
    public $phone;
    public $password;

    private $_user;

    public function rules() {
        return [
            [['phone', 'password'], 'required'],
        ];
    }
    public function attributeLabels()
    {
        return [
            'phone' => 'Телефон',
            'password' => 'Пароль',
        ];
    }
    public function login() {
        if ($this->validate()) {
            $user = $this->getUser();
            if ($user && $user->validatePassword($this->password)) {
                return Yii::$app->user->login($user);
            }
            $this->addError('password','Неверный телефон или пароль');
        }
        return false;
    }

    protected function getUser() {
        if ($this->_user === null) {
            $this->_user = User::findByPhone($this->phone);
        }
        return $this->_user;
    }
}
