<?php
// Подключаем необходимые зависимости
use yii\helpers\Html;
use yii\web\View;

// Регистрируем CSS стили
$css = <<< CSS
/* Основные цвета */
:root {
    --primary-black: #121212;
    --secondary-black: #1a1a1a;
    --dark-gray: #2d2d2d;
    --light-gray: #444;
    --primary-pink: #e83e8c;
    --secondary-pink: #ff6b9d;
    --soft-pink: rgba(232, 62, 140, 0.1);
    --text-primary: #f8f9fa;
    --text-secondary: #b0b0b0;
    --border-color: #333;
    --hover-black: #252525;
}

/* Общие стили для таблицы */
.table-container {
    background-color: var(--primary-black);
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
    overflow: hidden;
    border: 1px solid var(--border-color);
    margin-bottom: 30px;
    position: relative;
}

.table-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, var(--primary-pink), var(--secondary-pink));
    z-index: 10;
}

.table-container h2 {
    color: var(--text-primary);
    font-size: 28px;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 1px solid var(--border-color);
    position: relative;
    font-weight: 600;
}

.table-container h2::after {
    content: '';
    position: absolute;
    bottom: -1px;
    left: 0;
    width: 120px;
    height: 2px;
    background: linear-gradient(90deg, var(--primary-pink), transparent);
}

/* Анимация появления таблицы */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table-wrapper {
    animation: fadeInUp 0.8s ease-out forwards;
}

/* Стили для таблицы */
.table-custom {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    color: var(--text-primary);
    font-size: 15px;
}

.table-custom th {
    background-color: var(--dark-gray);
    color: var(--text-primary);
    font-weight: 600;
    padding: 18px 15px;
    text-align: left;
    border: none;
    position: relative;
    text-transform: uppercase;
    font-size: 14px;
    letter-spacing: 0.5px;
}

.table-custom th:not(:last-child)::after {
    content: '';
    position: absolute;
    right: 0;
    top: 50%;
    transform: translateY(-50%);
    height: 60%;
    width: 1px;
    background-color: var(--border-color);
}

.table-custom th:first-child {
    border-top-left-radius: 10px;
}

.table-custom th:last-child {
    border-top-right-radius: 10px;
}

.table-custom td {
    padding: 20px 15px;
    border-bottom: 1px solid var(--border-color);
    background-color: var(--secondary-black);
    transition: all 0.3s ease;
}

/* Анимация строк при наведении */
.table-custom tbody tr {
    opacity: 0;
    animation: fadeInRow 0.5s ease-out forwards;
}

@keyframes fadeInRow {
    from {
        opacity: 0;
        transform: translateX(-10px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.table-custom tbody tr:hover td {
    background-color: var(--hover-black);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
}

.table-custom tbody tr:last-child td {
    border-bottom: none;
}

.table-custom tbody tr:last-child td:first-child {
    border-bottom-left-radius: 10px;
}

.table-custom tbody tr:last-child td:last-child {
    border-bottom-right-radius: 10px;
}

/* Специальные стили для колонок */
.game-type {
    position: relative;
    padding-left: 25px;
}

.game-type::before {
    content: '';
    position: absolute;
    left: 10px;
    top: 50%;
    transform: translateY(-50%);
    width: 8px;
    height: 8px;
    background-color: var(--primary-pink);
    border-radius: 50%;
    box-shadow: 0 0 8px var(--primary-pink);
}

.game-date, .game-time {
    font-weight: 500;
    color: var(--text-primary);
}

.game-price {
    font-weight: 600;
    color: var(--secondary-pink);
    font-size: 16px;
}

/* Стили для кнопки */
.btn-pink {
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    color: white;
    border: none;
    border-radius: 8px;
    padding: 10px 20px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-size: 14px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(232, 62, 140, 0.3);
    position: relative;
    overflow: hidden;
    display: inline-block;
    text-decoration: none;
    text-align: center;
}

.btn-pink::after {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.7s ease;
}

.btn-pink:hover {
    color: white;
    text-decoration: none;
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(232, 62, 140, 0.4);
}

.btn-pink:hover::after {
    left: 100%;
}

.btn-pink:active {
    transform: translateY(-1px);
}

/* Стили для пустой таблицы */
.empty-table {
    text-align: center;
    padding: 50px 20px;
    color: var(--text-secondary);
    font-size: 18px;
    background-color: var(--secondary-black);
    border-radius: 10px;
    margin-top: 20px;
}

.empty-table i {
    font-size: 48px;
    color: var(--primary-pink);
    margin-bottom: 20px;
    display: block;
}

/* Адаптивность */
@media (max-width: 992px) {
    .table-container {
        padding: 15px;
    }
    
    .table-custom {
        font-size: 14px;
    }
    
    .table-custom th,
    .table-custom td {
        padding: 15px 10px;
    }
    
    .btn-pink {
        padding: 8px 15px;
        font-size: 13px;
    }
}

@media (max-width: 768px) {
    .table-wrapper {
        overflow-x: auto;
    }
    
    .table-custom {
        min-width: 700px;
    }
}

/* Анимация для заголовка */
.header-glow {
    position: relative;
    overflow: hidden;
}

.header-glow::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(232, 62, 140, 0.1) 0%, rgba(232, 62, 140, 0) 70%);
    z-index: 0;
}
CSS;

$this->registerCss($css);

// Регистрируем JavaScript для анимаций
$js = <<< JS
$(document).ready(function() {
    // Анимация строк таблицы с задержкой
    $('.table-custom tbody tr').each(function(index) {
        $(this).css('animation-delay', (index * 0.1) + 's');
    });
    
    // Анимация кнопок при наведении
    $('.btn-pink').on('mouseenter', function() {
        $(this).addClass('animated');
    });
    
    // Добавляем иконки для типов игр (если нужно)
    $('.game-type').each(function() {
        var gameType = $(this).text().trim().toLowerCase();
        var icon = '';
        
        switch(gameType) {
            case 'футбол':
                icon = '⚽';
                break;
            case 'баскетбол':
                icon = '🏀';
                break;
            case 'волейбол':
                icon = '🏐';
                break;
            case 'теннис':
                icon = '🎾';
                break;
            default:
                icon = '🎯';
        }
        
        $(this).html(icon + ' ' + $(this).text());
    });
    
    // Эффект при загрузке страницы
    setTimeout(function() {
        $('.table-container').addClass('loaded');
    }, 300);
});
JS;

$this->registerJs($js, View::POS_READY);
?>

<div class="table-container">
    <h2 class="header-glow">Ближайшие игры</h2>

    <div class="table-wrapper">
        <table class="table-custom">
            <thead>
            <tr>
                <th>Вид</th>
                <th>Игра</th>
                <th>Дата</th>
                <th>Время</th>
                <th>Адрес</th>
                <th>Цена</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php if (!empty($games)): ?>
                <?php foreach ($games as $game): ?>
                    <tr>
                        <td class="game-type"><?= Html::encode($game->game_type) ?></td>
                        <td><?= Html::encode($game->game_name) ?></td>
                        <td class="game-date"><?= Html::encode($game->game_date) ?></td>
                        <td class="game-time"><?= Html::encode($game->game_time) ?></td>
                        <td><?= Html::encode($game->address) ?></td>
                        <td class="game-price"><?= Html::encode($game->price) ?> ₽</td>
                        <td>
                            <?= Html::a('Записаться', ['site/create-request', 'id' => $game->id], [
                                'class' => 'btn-pink',
                                'data' => ['game-id' => $game->id]
                            ]) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">
                        <div class="empty-table">
                            <i>🎯</i>
                            <p>На данный момент нет запланированных игр</p>
                        </div>
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>